'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Briefvorlage_bearbeiten_Click()
On Error GoTo Err_Button_Briefvorlage_bearbeiten_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    'Prfen, ob Rechnungstabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Briefvorlagen")
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Briefvorlagen angelegt.", vbInformation, "Hinweis"
        Exit Sub
    End If
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    rst.Close
    Set dbs = Nothing
    
    AenderungsArt = "Korrektur"
    
    'Briefvorlage ffnen
    FormularName = "Briefvorlage"
    
    DoCmd.Close acForm, FormularName, acSaveYes
    DoCmd.OpenForm FormularName, , , , , , AktBriefvorlage
    
    
Exit_Button_Briefvorlage_bearbeiten_Click:
    Exit Sub

Err_Button_Briefvorlage_bearbeiten_Click:
    MsgBox err.Description
    Resume Exit_Button_Briefvorlage_bearbeiten_Click
    
End Sub

Private Sub Button_Briefvorlage_loeschen_Click()
    On Error GoTo ERROR_Button_Briefvorlage_loeschen_Click

    Dim dbs As Database
    Dim rst As Recordset
    Dim strFilter As String
    
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Serienbriefe"
    'FormularBereich = "Gebuehren"      'nicht notwendig!
    
    'Tabelle ffnen
    Set dbs = CurrentDb
    Set rst = Me.Serienbriefe_Liste.Form.RecordsetClone
    
    'wenn Datensatz vorhanden, dann lschen...
    If (rst.RecordCount = 0) Then
        Set dbs = Nothing
        MsgBox "Keine Briefvorlagen vorhanden.", vbInformation, "Hinweis"
    Else
        If MsgBox("Ausgewhlte Briefvorlage wirklich lschen?", vbYesNo + vbQuestion + vbDefaultButton2, "Briefvorlage lschen...") = vbNo Then
            Exit Sub
        End If
        
        strFilter = "SELECT * FROM Briefvorlagen WHERE [lfd_Nr] = " & AktBriefvorlage
        Set rst = dbs.OpenRecordset(strFilter)
        rst.Delete
        rst.Requery
        rst.Close
        Set dbs = Nothing
        
        '...und Formular zwecks Aktualisierung schlieen und wieder ffnen
        Me.Serienbriefe_Liste.Form.Requery
    
    End If

EXIT_Button_Briefvorlage_loeschen_Click:
    Exit Sub
    
ERROR_Button_Briefvorlage_loeschen_Click:
    MsgBox err.Description
    Resume EXIT_Button_Briefvorlage_loeschen_Click
    
End Sub

Private Sub Button_Briefvorlage_neu_Click()
On Error GoTo Err_Button_Briefvorlage_neu_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    'Neuen Datensatz anlegen und lfd_Nr merken
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Briefvorlagen")
    rst.AddNew
    rst.Update
    rst.Bookmark = rst.LastModified
    AktBriefvorlage = rst!lfd_Nr
    rst.Close
    Set dbs = Nothing
    
    AenderungsArt = "Neu"
    
    'Briefvorlage ffnen
    FormularName = "Briefvorlage"
    
    DoCmd.Close acForm, FormularName, acSaveYes
    DoCmd.OpenForm FormularName, , , , , , AktBriefvorlage
    
    
Exit_Button_Briefvorlage_neu_Click:
    Exit Sub

Err_Button_Briefvorlage_neu_Click:
    MsgBox err.Description
    Resume Exit_Button_Briefvorlage_neu_Click
    
End Sub

Private Sub Button_Serienbrief_Vorschau_Click()
On Error GoTo Err_Button_Serienbrief_Vorschau_Click
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    'Formular anzeigen
    DoCmd.OpenReport "Serienbrief_Hauptformular", acPreview
    'Formular und Unterformular auf Kunde und Jahr filtern
'    Reports.Item("Serienbrief_Hauptformular").Filter = "[lfd_Nr]=" & Me.lfd_Nr.Value
'    Reports.Item("Serienbrief_Hauptformular").Controls.Item("Ueberschrift").Caption = Me.Jahresauswahl.Value
    Reports.Item("Serienbrief_Hauptformular").Controls.Item("BriefvorlagenNummer").Caption = AktBriefvorlage
        
    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
    'Berichtsvorschau auf ganzes Blatt zoomen
    DoCmd.RunCommand acCmdFitToWindow


Exit_Button_Serienbrief_Vorschau_Click:
    Exit Sub

Err_Button_Serienbrief_Vorschau_Click:
    MsgBox err.Description
    Resume Exit_Button_Serienbrief_Vorschau_Click

End Sub

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click


    DoCmd.Close

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Activate()
    
    'Prfen, ob Briefvorlagentabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Briefvorlagen")
    If rst.RecordCount = 0 Then
        Me.Kundenauswahl.Enabled = False
        Me.Kunden_direkt.Enabled = False
        Me.Button_Briefvorlage_bearbeiten.Enabled = False
        Me.Button_Briefvorlage_loeschen.Enabled = False
        Me.Button_Serienbrief_Vorschau.Enabled = False
    Else
        Me.Kundenauswahl.Enabled = True
        Me.Kunden_direkt.Enabled = True
        Me.Button_Briefvorlage_bearbeiten.Enabled = True
        Me.Button_Briefvorlage_loeschen.Enabled = True
        Me.Button_Serienbrief_Vorschau.Enabled = True
    End If
    rst.Close
    Set dbs = Nothing

End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Kunden_direkt_GotFocus()
    Me.Kundenauswahl.DefaultValue = 1
End Sub

Private Sub Kunden_direkt_LostFocus()
    If IsNull(Me.Kunden_direkt.Value) Then Me.Kundenauswahl.DefaultValue = 0
End Sub

Private Sub Kunden_nur_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    Me.Kunden_direkt.SetFocus
End Sub
